REM
REM      TO REJECT PREDICTIONS THAT EXCEED LIMITS OF TRACKING SYSTEM
REM
REM                        GREG ROBERTS   APRIL 2000
REM                        V1.0  - ORIGINAL *.SAT FILES
REM                        V1.1  - NEW FORMAT FOR SAT*.* FILES

   CLS
   PRINT "                                                                             "
   PRINT "                                     FUDGE                                   "
   PRINT "                             V1.1    20 JUNE 2000                            "
   PRINT "                                                                             "
   PRINT " FUDGE is a program to try and remove impossible situations for the stepper  "
   PRINT " motor controlled satellite tracking program. Due to limits on the speed at  "
   PRINT " which a stepper motor can run there are occassions when the mount cannot    "
   PRINT " move through a certain angle in a specified time. This causes the satellite "
   PRINT " track to be lost and sometimes ties the system in a knot and the only exit  "
   PRINT " is to crash the computer and do a mount re - setup - ie set the mount on a  "
   PRINT " defined azimuth and elevation. Due to the fact that the mount has to perform"
   PRINT " two movements, one in azimuth and one in elevation, it is not possible to   "
   PRINT " easily define a precise limit of how much each one can change in a second so"
   PRINT " experience will dictate what FUDGE FACTOR to introduce to more or less      "
   PRINT " define general limits - further use of the resulting predictions will then  "
   PRINT " make it possible to refine the factors in azimuth and elevation.Generally   "
   PRINT " the FUDGE factor for elevation may be set as 1.0                            "

   CALL KEYCHECK

   CLS

   DEFDBL A - Z

REM  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
REM                  ENTER SYSTEM PARAMATERS
REM  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

   PRINT  "Please enter some parameters for your system : "
   PRINT  "          "
   INPUT  "Enter time for 90 degrees movement in altitude (secs) "; ELTIME

   INPUT  "Enter time for 360 degrees movement in azimth (secs)  "; AZTIME

   INPUT  "Enter your AZ fudge factor - number less than OR equal to 1.0 "; FUDGE1
   INPUT  "Enter your AL fudge factor - number less than OR equal to 1.0 "; FUDGE2

REM  COMPUTE ANGULAR VELOCITY LIMITS FOR AZ AND EL

    ELLIMIT = 90.0 / ELTIME

    AZLIMIT = 360.0/ AZTIME

REM

REM                         FUDGE FACTOR = FUDGE
REM  The above values are when no other operations are taking place. It
REM  seems that azimuth moves much slower when tracking and experience seems
REM  to indicate it is moving at about 0.4 of max speed. It does not appear
REM  to be the case with elevation, so for the present adopt an azimuth speed
REM  that is 0.4 of maximum -  experience may change this


    N = 1


REM   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
REM               MAKE LIST OF SAT*.* FILES TO PROCESS
REM   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

     SHELL "DIR SAT*.*>FILE.TXT"
     SHELL "SORT<FILE.TXT>SORTED.LIS"
     KILL "FILE.TXT"

     AA$ = "SORTED.LIS"
     BB$ = "PROCESS.LIS"

     OPEN AA$ FOR INPUT AS #1
     OPEN BB$ FOR OUTPUT AS #2

     FOR Q = 1 TO 7
     LINE INPUT#1, RUBBISH$
     PRINT RUBBISH$
     NEXT

10 REM

     IF EOF(1) GOTO 20
     LINE INPUT #1,DATAIN$
     DATIN$ = LEFT$(DATAIN$,8) + "." + MID$(DATAIN$,10,3)
     NEWNAME$ = DATIN$
     PRINT #2,NEWNAME$

     GOTO 10

20 REM

     CLOSE #1
     CLOSE #2


   REM    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   REM            READ FILE NAME TO PROCESS FROM PROCESS.LIS
   REM    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

     CLS

     OPEN "PROCESS.LIS" FOR INPUT AS #1

30   IF EOF(1) THEN GOTO 500 : REM ALL FILES COMPLETE

     LINE INPUT#1,CHECK$     : REM NAME OF SAT*.* FILE TO PROCESS

     RESUL$  = MID$(CHECK$,4,5) :

     ENDS$    = MID$(CHECK$,9,4)

     RESULT$ = "OUT" + RESUL$ + ENDS$ : REM NAME OF OUTPUT FILE

     OPEN RESULT$ FOR OUTPUT AS #2


   REM  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   REM                PROCESS SPECIFIC FILE
   REM  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

     OPEN CHECK$ FOR INPUT AS #3   : REM PROCESS SPECIFIC FILE

     DIM TIME(1000),AZ(1000),EL(1000)

     N = N

     LINE INPUT #3, GARBAGE$
     NAMES$ = MID$(GARBAGE$,14,14)

100  IF EOF(3) GOTO 200

     LINE INPUT #3, DATANEW$

     HRS = VAL(LEFT$(DATANEW$,2))
     MIN = VAL(MID$(DATANEW$,4,2))
     SEC = VAL(MID$(DATANEW$,7,2))

     TIME(N) = HRS + MIN/60 + SEC/3600  : rem  hrs.hrs
     AZ(N) = VAL(MID$(DATANEW$,11,8))
     EL(N) = VAL(MID$(DATANEW$,22,7))

     N = N + 1

     GOTO 100

200  REM    DATA HAS BEEN READ INTO MEMORY

     'CLS
     PRINT #2,"Satellite = ";NAMES$
     PRINT #2, "    "
     PRINT #2," AZ(N+1)   AZ(N)   CHANGEAZ  TIMEAZ(sec)  EL(N+1)   EL(N)  CHANGEEL  TIMEEL(sec)"

     FOR N = 1 TO N-2

     STEPTIME = TIME(N+1) - TIME(N)
     CHANGEAZ = ABS(AZ(N+1) - AZ(N))    : REM CHANGE IN AZIMUTH

     IF CHANGEAZ > 250 THEN CHANGEAZ = 360 - CHANGEAZ  : REM ANOTHER FUDGE!

     TIMEAZ = CHANGEAZ/(STEPTIME*3600.0*AZLIMIT*FUDGE1)

     CHANGEEL = ABS(EL(N+1) - EL(N))    : REM CHANGE IN ELEVATION
     TIMEEL = CHANGEEL/(STEPTIME*3600.0*ELLIMIT*FUDGE2)

     PRINT#2,USING "###.###  "; AZ(N+1),AZ(N),CHANGEAZ;

     PRINT#2,USING "   ###.##"; TIMEAZ;

     IF TIMEAZ>1 THEN PRINT#2,"#";

     IF TIMEAZ<=1 THEN PRINT#2," ";

     PRINT#2, "      ";

     PRINT#2,USING " ###.## "; EL(N+1),EL(N),CHANGEEL;

     PRINT#2,USING "  ###.##"; TIMEEL

     NEXT N

     PRINT#2, "   "
     PRINT#2," If the value of TIMEAZ >= 1.00 then BEYOND LIMIT";
     PRINT#2," and the system may not be able to track the satellite"

     CLOSE #2
     CLOSE #3

REM   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
REM                   END OF A SPECIFIC SATELLITE
REM   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      N = 1
      GOTO 30  : REM READ NEXT SATELLITE FILE TO PROCESS


REM  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
REM                         COMPLETE
REM  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

500  PRINT "JOB DONE "

     PRINT " Input file starts with SAT*****.*** and the corresponding OUTPUT"
     PRINT " file is named OUT*****.***. Examine the latter file for results."

     KILL "PROCESS.LIS"
     KILL "SORTED.LIS"
     STOP


REM  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SUB KEYCHECK

REM        CHECK USER RESPONSE
PRINT " "
PRINT "Press <ENTER> to continue or <ESC> to stop."
INVAL% = 0
DO UNTIL INVAL% = 13 OR INVAL% = 27
CH$ = INKEY$
IF CH$<>"" THEN INVAL% = ASC(CH$)
LOOP
IF INVAL% = 13 THEN PRINT "Continuing...."
IF INVAL% = 27 THEN PRINT "Exiting": STOP

END SUB