10000   REM         TO SORT OUT SATELLITE ELEMENTS FILE
10100   REM
10200   REM    HAVE MASTER FILE OF CATALOG NUMBERS WANTED.
10300   REM    READ THIS FILE ONCE AND STORE IN MEMORY
10400   REM    READ IN ELEMENTS FILE, READ IN GROUPS OF THREE LINES
10500   REM    CHECK CATALOG NUMBER IN 2ND LINE AGAINST MEMORY DATABASE
10600   REM    IF MATCHES, SAVE THE THREE LINES TO AN APPEND FILE.
10700   REM    IF NO MATCH SKIP THESE THREE LINES AND GO ONTO NEXT THREE
10800   REM
10900   REM                        by
10901   REM            GREG ROBERTS   JUNE 1999
17326   REM
17327      CLS
17330      PRINT "Extract elements from ALLDAT.TLE using a list"
17340      PRINT " of satellite catalog numbers in CATALOG.DXT "
17345      CLS
17350 REM
17360 REM    ----------------------------------------------------
17370 REM    +                                                  +
17380 REM    +                                                  +
17390 REM    +                                                  +
17400 REM    +                                                  +
17410 REM    ----------------------------------------------------
17420 REM
17478 REM
17530 REM    Now count number of SATS IN CATALOG.DXT
17535 REM
17536 rem
17541      DIM SATS$(1600)
17542      NENTRIES = 0
17543      INPUT "Enter name of your index catalog, eg CATALOG.DXT"; INCAT$
17545      OPEN INCAT$ FOR INPUT AS #2
17550      COUNT = 0
17560      COUNT = COUNT + 1
17570      LINE INPUT #2, IDENT11$
17580      IF EOF(2) GOTO 17600
17590      GOTO 17560
17600      CLOSE (2)
17605      PRINT "Number of catalog SATELLITES = "; COUNT
17606      ON ERROR GOTO 17610: KILL "SAT.TLE"
17610 REM
17620 REM      Number of SATELLITES in INPUT CATALOG (*.DXT) = COUNT
17630 REM
17640 REM      Now count number of lines in ALLDAT.TLE
17642 REM
17643      INPUT "Enter name of your elements catalog(*.TLE) "; elcat$
17650      OPEN ELCAT$ FOR INPUT AS #1
17655      ON ERROR GOTO 17725:  ' NO *.TLE FILE FOUND
17660      COUNTER = 0
17670      COUNTER = COUNTER + 1
17680      LINE INPUT #1, IDENT1$: REM NEED TO READ 3 LINES OF DATA
17681      LINE INPUT #1, IDENT2$: REM SINCE 3 LINES OF DATA PER
17682      LINE INPUT #1, IDENT3$: REM SATELLITE
17690      IF EOF(1) GOTO 17710
17700      GOTO 17670
17710      CLOSE (1)
17720      PRINT "Number of SATELLITES in ELEMENTS catlog = "; COUNTER
17721      GOTO 17730
17725      PRINT " Elements File *.TLE not found "
17730 REM
17740 REM         Now read CATALOG.DXT into memory
17750 REM      The number of positions is given by COUNT
17767 REM
17770      OPEN incat$ FOR INPUT AS #2
17775      N = 1
17780      LINE INPUT #2, IDENT2$
17781      SATS$(N) = IDENT2$
17807 REM
17830      N = N + 1
17840      IF N > COUNT THEN GOTO 17860
17850      GOTO 17780
17855 REM
17860 REM  SATELLITE CATALOG NUMBERS HAVE BEEN READ IBTO MEMORY
17865 REM
17870      PRINT "CATALOG numbers have been read into memory"
17871      PRINT " Please standby - this could take a while "
17872 rem
17875 REM
17876 REM  **************************************************************
17878 REM
17880 REM             NOW OPEN DATA FILE AND COMPARE NAMES
17890 REM
17900      OPEN elcat$ FOR INPUT AS #1
17905      ON ERROR GOTO 18341            ' no elcat$
17910      OPEN "SAT.TLE" FOR output AS #3
17915      ON ERROR GOTO 18341            ' no SAT.tle
17920      COUNTF = 0
17930      IF COUNTF = COUNTER THEN GOTO 18280: REM job finished
17940      LINE INPUT #1, IDENT1$  ' :print ident1$
17941      LINE INPUT #1, IDENT2$  ' :print ident2$
17942      LINE INPUT #1, IDENT3$  ' :print ident3$
17950      COUNTF = COUNTF + 1
17960      CATNO$ = MID$(IDENT2$, 3, 5) :' REM  element file cat number
17990 REM
18000 REM     Now search SATS$ array for CATNO$
18010 REM
18011 rem     sats$(n) = number of catalog number required

18020      FOR K = 1 TO COUNT

18022      SATNUM$ = MID$(SATS$(K),1, 5)

18023 REM  CATALOG NUMBER REQUIRED

18025 REM  DETAILS FOR SATELLITE REQUIRED

18026      HEADER$ = MID$(SATS$(K),7,70)

18030      IF SATNUM$ = CATNO$ THEN GOTO 18066:  ' REM SAVE DATA **********
18040      NEXT K
18060      GOTO 17930


18066    '  print" satnum$ = ";satnum$ ;

18070 REM     Save data in SAT.TLE
18090 REM
18100 REM    -----------------------------------------------------
18110 REM    +                                                   +
18120 REM    +     PART 2  - WRITE DATA TO NEWELS.TLE            +
18130 REM    +                                                   +
18140 REM    -----------------------------------------------------
18150 REM
18160 REM              Write data to SAT.TLE
18170 REM
18180      PRINT #3, HEADER$: REM REPLACE HEADER WITH ONE FROM CATALOG.DXT
18190      PRINT #3, IDENT2$
18200      PRINT #3, IDENT3$
18231      NENTRIES = NENTRIES + 1

18261      GOTO 17930
18270 REM
18280 REM   JOB COMPLETED
18300      CLOSE : BEEP
18310      PRINT "Job now completed "
18315      PRINT "No of entries = "; NENTRIES
18340      PRINT : GOTO 18342
18341      PRINT "missing files "
18342 REM
19140      END

